### Méthode alternative (ligne de commande seulement)

```bash

    sudo fdisk /dev/mmcblk0
Ex:`sudo fdisk /dev/sdb2`.

- Supprime la 2e partition (`d`).
- Choisir (2)
- Recrée-la (`n`) en **gardant le même point de départ** (bloc Start identique).
- (p) pour Primary Partition
-  choisir  (2) et prendre le Default secteur de dépard Ex: 1050624 Debut
	et Default secteur pour la fin Ex:( 62333951 pour une carte de 32Go )
-Réponde Non a la question de Signature  (N)
- Sauvegarde (`w`).
- Puis exécute `sudo resize2fs /dev/mmcblk0p2`.
            Ex:`sudo resize2fs /dev/sdb2`.
			
C’est sans perte si le **début de la partition** reste inchangé.[^1_9]

***

En résumé, la procédure est :

1. Sauvegarde tes données.
2. Étends la partition avec **GParted** ou **fdisk**.
3. Redimensionne le **système de fichiers** avec `resize2fs`.

Cela fera que ta partition Linux occupera toute la carte SDHC de 32 Go.


sudo umount /dev/mmcblk0p2
sudo e2fsck -f /dev/mmcblk0p2
sudo resize2fs /dev/mmcblk0p2

sudo e2fsck -fy /dev/sdb2

Lorsque e2fsck affiche plusieurs erreurs du type "Inode ####, i_blocks is ..., should be ...", cela signifie que la table d’allocation des blocs a plusieurs incohérences, souvent dues à un ancien redimensionnement, clonage d’image, ou arrêt inapproprié du système.

​
Ce que cela veut dire

Chaque message correspond à un inode (fichier ou dossier) dont la description interne ne correspond plus réellement aux blocs sur le disque.

​
e2fsck détecte cette anomalie et te demande s’il faut corriger la valeur. Ces messages sont typiques quand un système de fichiers a été copié ou étendu manuellement (comme dans ton cas après agrandissement d’une image 8 Go vers 32 Go).
Ce qu’il faut faire

Tu peux laisser e2fsck tout corriger automatiquement :

bash
sudo umount /dev/sdb2
sudo e2fsck -fy /dev/sdb2



Relance e2fsck jusqu’à ce qu’il affiche “clean” à la fin.

Si les incohérences persistent, tu peux forcer une vérification des blocs physiques (utile si ta carte SD est vieillissante) :

bash
sudo e2fsck -fyc /dev/sdb2

L’option -c utilise badblocks pour détecter et isoler les blocs défectueux.

    ​

Après ces étapes, ton système de fichiers devrait être propre et tu pourras relancer resize2fs /dev/sdb2 pour que la capacité totale soit disponible.


Le message que tu vois, du type :
writable: 88784/1853280 (0.2% non-contiguous) est parfaitement normal et ne signale aucun problème. Il s’agit simplement d’un résumé du système de fichiers ext4 produit par e2fsck, indiquant le taux de fragmentation et les informations d’allocation des blocs.​




Tu peux le vérifier avec :

bash
sudo tune2fs -l /dev/sdb2 | grep "Block size"

Cette commande retournera une ligne du type :

    text
    Block size: 4096

Exemple

    Si ton système a un bloc de 4096 octets, alors :

        Un fichier de 100 octets occupe tout de même 4096 octets sur le disque.

        Un fichier de 10 000 octets occupera 3 blocs, soit 12 288 octets réels.

En résumé, sur ton système, 1 bloc = 4096 octets (4 Ko) dans presque tous les cas actuels.
​




























